$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });
    driver.defineSteps([
      {
        element: '#abaGeral',
        popover: {
          title: 'Campos de Filtro',
          description: 'Campos para filtrar o pedido a ser liberado.',
          position: 'bottom'
        }
      },
      {
        element: '#btnConsultar',
        popover: {
          title: 'Botão Consultar',
          description: 'Clique aqui para realizar a consulta de pedidos.',
          position: 'left'
        }
      },
      {
        element: '#btnLiberar',
        popover: {
          title: 'Botão Confirmar',
          description: 'Clique aqui para liberar/bloquear os pedidos selecionados.',
          position: 'left'
        }
      }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {

  const columns = [{ data: 'LOCAL' }, { data: 'DESCRICAO' }, { data: 'ATIVO' }, { data: 'REMOVER', width: '15px' }];
  const columnsHist = [{ data: 'LOCAL' }, { data: 'DESCRICAO' }, { data: 'ATIVO' }];

  addPesquisaAutocompleta();
  criaDataTablePadrao('#tabelaProdutos', false, false, false, false, true, false, '500px');
  criaDataTablePadrao('#tabelaLocais', false, false, false, false, true, false, '200px', null, columns, [2]);
  criaDataTablePadrao('#tabelaHistorico', false, false, false, false, true, false, '200px', null, columnsHist, [2]);

  await buscaValoresPadroesTela();

  $('#txtBarra').on('blur', async function () {
    if ($(this).val() == '') {
      return;
    }
    await buscaProdutos();
  });

  $('#btnConsultar').on('click', async () => { await buscaProdutos() });

  // $('#btnAdicionar').on('click', () => { $('#modalAdicionar').modal('show') });

  $('#tabelaProdutos').on('click', 'tr', async function () {
    $('.selected').removeClass('selected');
    $(this).closest('tr').addClass('selected');
    await buscaLocaisProduto($(this).closest('tr')[0].children[0].innerHTML, $(this).closest('tr')[0].children[2].innerHTML, $(this).closest('tr')[0].children[3].innerHTML, $(this).closest('tr')[0].children[4].innerHTML);
  });

  $('#btnConfirmar').on('click', async function () {
    await gravaDados();
  });

  $('#tabelaLocais').on('click', '#btn-excluir', async function () {
    const data = $("#tabelaLocais").DataTable().row($(this).parents("tr")).data();
    $("#tabelaHistorico").DataTable().row.add(data).draw(false);
    $("#tabelaLocais").DataTable().row($(this).parents("tr")).remove().draw(false);
  });

  $('#tabelaProdutos').on('click', '#btn-foto', async function () {
    const data = $("#tabelaProdutos").DataTable().row($(this).parents("tr")).data();
    await buscaFoto(data.CODIGO);
  });

  $('#modalAdicionar').on('hidden.bs.modal', function (_) {
    $('#txtLocal').val('');
  });

  function addLocal() {
    if ($('#tabelaProdutos .selected').length == 0) {
      msgAlerta('Necessário selecionar um produto para adicionar um local.');
      $('#txtLocal').val('');
      return;
    }

    if (pegaChave('#txtLocal') == '') {
      msgAlerta('Necessário adicionar um local para adicioná-lo.');
      return;
    }

    if (validaLocalExiste(pegaChave('#txtLocal'))) {
      msgAlerta('Local já foi adicionado, favor verificar.');
      $('#txtLocal').val('');
      return;
    }

    removeLocalHistorico(pegaChave('#txtLocal'));

    $("#tabelaLocais").DataTable().row.add({ LOCAL: pegaChave('#txtLocal'), DESCRICAO: pegaDescricao('#txtLocal'), ATIVO: 'S', REMOVER: retornaBotaoExcluir() }).draw(false);
    $('#modalAdicionar').modal('hide');
    $('#txtLocal').val('');
  }

  async function buscaFoto(codigo) {
    try {
      const response = await requisicao('GET', '/Sisplan/Funcoes/v1/FotoItem?', `codigo=${codigo}`, null);

      if (!response) {
        return;
      }
      const jsonStr = await response.json();
      if (response.status != 200) {
        $(".imagepreview").attr('src', `${BASE_URI}/dist/img/prod-1.png`);
        $('#imagemodal').modal('show');
        return;
      }

      const sBase64 = jsonStr;
      $(".imagepreview").attr('src', `data:image/png;base64,${sBase64.mensagem}`);
      $('#imagemodal').modal('show');

    } catch (error) {
      console.error(error);
      $(".imagepreview").attr('src', `${BASE_URI}/dist/img/prod-1.png`);
      $('#imagemodal').modal('show');
    }
  }

  function validaLocalExiste(sLocal) {
    let retorno = false;
    $("#tabelaLocais").DataTable().rows().data().map(item => {
      if (item.LOCAL == sLocal) {
        retorno = true;
      }
    });
    return retorno;
  }

  function removeLocalHistorico(sLocal) {
    $("#tabelaHistorico").DataTable().rows().data().map((item, index) => {
      if (item.LOCAL == sLocal) {
        $("#tabelaHistorico").DataTable().row(index).remove().draw(false);
      }
    });
  }

  async function gravaDados() {
    if (pegaChave('#txtDeposito') == '') {
      msgAlerta('Necessário informar um depósito para continuar.');
      return;
    }

    if ($('.selected').length == 0) {
      msgAlerta('Nenhum produto selecionado, impossível continuar.');
      return;
    }

    $.LoadingOverlay('show');
    try {

      let arrLocais = [];

      $("#tabelaLocais").DataTable().rows().data().map(item => {
        arrLocais.push({
          ATIVO: 'S',
          LOCAL: item.LOCAL
        })
      });

      $("#tabelaHistorico").DataTable().rows().data().map(item => {
        arrLocais.push({
          ATIVO: 'N',
          LOCAL: item.LOCAL
        })
      });

      const loc_est = {
        CODIGO: $('.selected').closest('tr')[0].children[0].innerHTML,
        COR: $('.selected').closest('tr')[0].children[2].innerHTML,
        TAM: $('.selected').closest('tr')[0].children[3].innerHTML,
        QUALIDADE: $('.selected').closest('tr')[0].children[4].innerHTML,
        DEPOSITO: pegaChave('#txtDeposito'),
        LOCAIS: arrLocais
      }

      const response = await requisicao('POST', '/sisplan/localizacao_estoque/v1/gravar?', '', JSON.stringify(loc_est));

      if (!response) {
        $.LoadingOverlay('hide');
        return;
      }

      if (response.status != 200) {
        $.LoadingOverlay('hide');
        const jsonStr = await response.json();
        msgErro(jsonStr.mensagem);
        return;
      }

      criaMensagemSucesso('Localização gravada com sucesso.');
    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  async function buscaLocaisProduto(sCodigo, sCor, sTam, sQualidade) {
    $.LoadingOverlay('show');
    try {

      const dadosSelect = {
        tabela: 'LOCAL_ESTOQUE',
        camposSelect: ['LOCAL_ESTOQUE.LOCAL', 'CAD_LOC_ESTOQ.DESCRICAO', 'LOCAL_ESTOQUE.ATIVO'],
        leftJoin: [{ tabela: 'CAD_LOC_ESTOQ', condicao: 'CAD_LOC_ESTOQ.CODIGO = LOCAL_ESTOQUE.LOCAL' }],
        where: [`LOCAL_ESTOQUE.CODIGO = '${sCodigo}' AND LOCAL_ESTOQUE.COR = '${sCor}' AND LOCAL_ESTOQUE.TAM = '${sTam}' AND LOCAL_ESTOQUE.DEPOSITO = '${pegaChave('#txtDeposito')}' AND LOCAL_ESTOQUE.QUALIDADE = '${sQualidade}'`]
      };
      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
      if (!jsonStr) {
        msgAlerta('Não foi possível buscar os dados dos locais.');
        return;
      }

      let arrLocaisAtivos = [];
      let arrLocaisInativos = [];

      jsonStr.map(item => {
        if (item.ATIVO == 'S') {
          arrLocaisAtivos.push(item);
        } else {
          arrLocaisInativos.push(item);
        }
      });

      $("#tabelaLocais").DataTable().rows().remove().draw(false);
      $("#tabelaHistorico").DataTable().rows().remove().draw(false);

      insereLocais(arrLocaisAtivos);
      insereHistorico(arrLocaisInativos);
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  function insereLocais(sDados) {
    if (sDados.length == 0) {
      return;
    }
    let dataSetCols = [];
    const keys = Object.keys(sDados[0]);
    for (var k in keys) {
      dataSetCols.push({
        'data': keys[k]
      });
    };
    dataSetCols.push({
      'data': 'REMOVER',
      'width': '15px'
    });
    dataSetCols[3].render = function (data, type, row, meta) {
      return retornaBotaoExcluir();
    };
    criaDataTablePadrao('#tabelaLocais', false, false, false, false, true, false, '200px', sDados, dataSetCols, [2]);
  }

  function insereHistorico(sDados) {
    if (sDados.length == 0) {
      return;
    }
    let dataSetCols = [];
    const keys = Object.keys(sDados[0]);
    for (var k in keys) {
      dataSetCols.push({
        'data': keys[k]
      });
    };
    criaDataTablePadrao('#tabelaHistorico', false, false, false, false, true, false, '200px', sDados, dataSetCols, [2]);
  }

  async function buscaProdutos() {
    $.LoadingOverlay('show');
    try {
      if (pegaChave('#txtDeposito') == '') {
        msgAlerta('Necessário informar um depósito para buscar.');
        return;
      }

      $("#tabelaLocais").DataTable().rows().remove().draw(false);
      $("#tabelaHistorico").DataTable().rows().remove().draw(false);

      const sWhere = retornaFiltro();
      const dados = await retornaDados(sWhere);

      if (dados.length == 0) {
        msgAlerta('Nenhum dado encontrado, favor verificar os filtros.')
        return;
      }

      insereDadosTabela(dados);
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  async function retornaDados(sWhere) {
    const dadosSelect = {
      tabela: 'PRODUTO',
      camposSelect: ['PA_ITEN.CODIGO', 'PRODUTO.DESCRICAO', 'PA_ITEN.COR', 'PA_ITEN.TAM', 'PA_ITEN.TIPO'],
      leftJoin: [{ tabela: 'PA_ITEN', condicao: 'PRODUTO.CODIGO = PA_ITEN.CODIGO' }],
      where: [`${sWhere}`]
    };
    const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
    if (!retornoSelect) {
      msgAlerta('Não foi possível buscar os dados dos produtos.');
      return;
    }
    return retornoSelect;
  }

  async function buscaValoresPadroesTela() {
    $.LoadingOverlay('show');
    try {

      const classValores = { POSICAO: '1' };
      const response = await requisicao('POST', '/sisplan/valorespadroes/v1/buscar?', '', JSON.stringify(classValores), null);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();

      insereValor('#txtDeposito', jsonStr.deposito);
    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  function insereDadosTabela(sDados) {
    let dataSetCols = [];

    const keys = Object.keys(sDados[0]);

    for (var k in keys) {
      dataSetCols.push({
        'data': keys[k]
      });
    };

    dataSetCols.push({
      'data': 'FOTO',
      'width': '10px'
    });
    dataSetCols[5].render = function (data, type, row, meta) {
      return retornaBotaoFoto();
    };

    criaDataTablePadrao('#tabelaProdutos', false, false, false, false, true, false, '500px', sDados, dataSetCols);
  }

  function retornaFiltro() {
    let where = ' 1 = 1 ';
    where += pegaChave('#txtCodigo') != '' ? ` AND PA_ITEN.CODIGO = '${pegaChave('#txtCodigo')}' ` : '';
    where += pegaChave('#txtCor') != '' ? ` AND PA_ITEN.COR = '${pegaChave('#txtCor')}' ` : '';
    where += pegaChave('#txtTamanho') != '' ? ` AND PA_ITEN.TAM = '${pegaChave('#txtTamanho')}' ` : '';
    where += pegaChave('#txtDeposito') != '' ? ` AND PA_ITEN.DEPOSITO = '${pegaChave('#txtDeposito')}' ` : '';
    where += pegaValor('#txtBarra') != '' ? ` AND (PA_ITEN.BARRA = '${pegaValor('#txtBarra')}' OR PA_ITEN.BARRA28 = '${pegaValor('#txtBarra')}' OR PA_ITEN.BARRACLI = '${pegaValor('#txtBarra')}') ` : '';
    return where;
  }

  function retornaBotaoExcluir() {
    return '<div class="divBtnOpcoes"> ' +
      '       <button class="botaoOpcoes" type="button" title="Excluir" id="btn-excluir"><span class="fas fa-trash-alt" style="color:red"></span></button>  ' +
      '     </div>';
  }

  function retornaBotaoFoto() {
    return '<div class="divBtnOpcoes"> ' +
      '       <button class="botaoOpcoes" type="button" title="Foto" id="btn-foto"><span class="fas fa-image" style="color:grey"></span></button>  ' +
      '     </div>';
  }

  function addPesquisaAutocompleta() {
    $('#txtCodigo').autocompleta(3, `JSON={ "tabela":"PRODUTO", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": null }`);
    $('#btn-Codigo').pesquisa_serverside(['#txtCodigo'], ['CODIGO'], ['DESCRICAO'], `{"tabela":"PRODUTO", "camposSelect":[ "CODIGO", "CODIGO2", "DESCRICAO" ], "where": null}`, "Pesquisa Produto");
    $('#btn-limpa-Codigo').on('click', function () { $('#txtCodigo').val(''); });

    $('#txtCor').autocompleta(1, `JSON={ "tabela":"CADCOR", "camposSelect":["COR CHAVE, DESCRICAO DESCRICAO"], "where": null}`);
    $('#btn-Cor').pesquisa('#txtCor', 'COR', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"CADCOR", "camposSelect":[ "COR", "DESCRICAO" ], "where": null}', 'Pesquisa Cor', 'CADCOR');
    $('#btn-limpa-Cor').on('click', function () { $('#txtCor').val('') });

    $('#txtTamanho').autocompleta(1, `JSON={ "tabela":"TABTAM", "camposSelect":["TAM CHAVE, TAM DESCRICAO"], "where": null}`);
    $('#btn-Tamanho').pesquisa('#txtTamanho', 'TAM', 'TAM', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"TABTAM", "camposSelect":[ "TAM", "TAM" ], "where": null}', 'Pesquisa Tamanho', 'TABTAM');
    $('#btn-limpa-Tamanho').on('click', function () { $('#txtTamanho').val('') });

    $('#txtDeposito').autocompleta(1, `JSON={ "tabela":"DEPOSITO", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": null}`);
    $('#btn-Deposito').pesquisa('#txtDeposito', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa Depósito', 'DEPOSITO');
    $('#btn-limpa-Deposito').on('click', function () { $('#txtDeposito').val('') });

    $('#txtLocal').autocompleta(1, `JSON={ "tabela":"CAD_LOC_ESTOQ", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": null}`);
    $('#btnAdicionar').pesquisa('#txtLocal', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"CAD_LOC_ESTOQ", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa Local', 'CAD_LOC_ESTOQ', '', addLocal);
    $('#btn-limpa-Local').on('click', function () { $('#txtLocal').val('') });
  }
});